import fetch from 'isomorphic-unfetch';
import dynamic from 'next/dynamic';

// import Notes from '../components/Notes';
const Notes = dynamic(() => import('../components/Notes'));

const API = process.env.API;

const Page = ({ user, token, session: { speaker, ...session } }) => {
  return session ? (
    <>
      <h1>{session.title}</h1>
      <p>⏰ {session.time}</p>
      {session.description.split(/\n/).map((p, i) => (
        <p key={i}>{p}</p>
      ))}
      <div className="speaker">
        <style jsx>{`
          .speaker {
            display: flex;
            align-items: flex-start;
            margin-top: 40px;
          }

          h2 {
            margin-top: 0;
          }

          img {
            border-radius: 5px;
            width: 200px;
            object-fit: scale-down;
            margin-left: 5px;
          }

          blockquote {
            font-style: italic;
            border-left: 5px solid #ccc;
            padding-left: 20px;
            margin-left: 2px;
          }

          h2,
          h3,
          img {
            display: ${process.env.HIDE_SPEAKERS ? 'none' : 'auto'};
          }
        `}</style>
        <div>
          <h2>About {speaker.name}</h2>
          <h3>
            <a href={`https://twitter.com/${speaker.twitter}`}>
              @{speaker.twitter}
            </a>
          </h3>
          <p>What's your tech origin story?</p>
          <blockquote>
            {speaker.bio.split(/\n/).map((p, i) => (
              <p key={i}>{p}</p>
            ))}
          </blockquote>
        </div>
        <img src={speaker.photo} />
      </div>
      {user && <Notes token={token} slug={session.slug} />}
    </>
  ) : (
    <p>oh</p>
  );
};

Page.getInitialProps = async ({ query }) => {
  const res = await fetch(`${API}/session/${query.slug}`);
  const session = await res.json();
  return {
    session,
  };
};

export default Page;
