import App, { Container } from 'next/app';
import { MDXProvider } from '@mdx-js/tag';
import Link from 'next/link';
import Layout from '../components/Layout';
import { appWithUser } from '../lib/withUser';

// Map HTML tags to React components
const components = {
  a: ({ children, href, ...props }) => (
    <Link href={href}>
      <a {...props}>{children}</a>
    </Link>
  ),
};

class MyApp extends App {
  static async getInitialProps({ Component, ctx }) {
    let pageProps = {};

    if (Component.getInitialProps) {
      pageProps = await Component.getInitialProps(ctx);
    }

    return { pageProps: { ...pageProps, user: ctx.user, token: ctx.token } };
  }

  render() {
    const { Component, pageProps } = this.props;
    return (
      <Container>
        <MDXProvider components={components}>
          <Layout {...pageProps}>
            <Component {...pageProps} />
          </Layout>
        </MDXProvider>
      </Container>
    );
  }
}

export default appWithUser(MyApp);
