/* eslint-env node */
const fetch = require('isomorphic-unfetch');
const withBundleAnalyzer = require('@zeit/next-bundle-analyzer');
const webpack = require('webpack');
const withMDX = require('@zeit/next-mdx')({
  extension: /\.mdx?$/,
});

module.exports = withBundleAnalyzer(
  withMDX({
    analyzeServer: ['server', 'both'].includes(process.env.BUNDLE_ANALYZE),
    analyzeBrowser: ['browser', 'both'].includes(process.env.BUNDLE_ANALYZE),
    bundleAnalyzerConfig: {
      server: {
        analyzerMode: 'static',
        reportFilename: '../../bundles/server.html',
      },
      browser: {
        analyzerMode: 'static',
        reportFilename: '../bundles/client.html',
      },
    },
    exportPathMap: async () => {
      const res = await fetch(`${process.env.API}/event/2018`);
      const json = await res.json();
      const slugs = json.reduce(
        (acc, { slug }) => ({
          [`/session/${slug}`]: { page: '/session', query: { slug } },
          ...acc,
        }),
        {}
      );
      return {
        '/': { page: '/' },
        '/about': { page: '/about' },
        '/aboot': { page: '/aboot' },
        '/contact': { page: '/contact' },
        ...slugs,
      };
    },
    pageExtensions: ['js', 'jsx', 'mdx'],
    webpack: (config, { defaultLoaders }) => {
      config.module.rules.push({
        test: /\.css$/,
        use: [
          defaultLoaders.babel,
          {
            loader: require('styled-jsx/webpack').loader,
            options: {
              type: 'scoped',
            },
          },
        ],
      });

      config.plugins.push(
        new webpack.EnvironmentPlugin({
          HIDE_SPEAKERS: 0,
          API: 'http://localhost:9000',
        })
      );

      return config;
    },
  })
);
