import Header from './Header';
import Footer from './Footer.js';
import NProgress from 'nprogress';
import router from 'next/router';

router.onRouteChangeStart = () => NProgress.start();
router.onRouteChangeComplete = () => NProgress.done();
router.onRouteChangeError = () => NProgress.done();

export default ({ children, ...props }) => (
  <div id="root">
    <Header {...props} />
    <main>{children}</main>
    <Footer {...props} />
  </div>
);
