/* eslint-env node */
const express = require('express');
const next = require('next');

const port = process.env.PORT || 3000;
const dev = process.env.NODE_ENV !== 'production';
const app = next({ dev });
const handle = app.getRequestHandler();

const { join } = require('path');
const { parse } = require('url');

app
  .prepare()
  .then(() => {
    const server = express();

    // custom handlers go here…

    server.get('/service-worker.js', (req, res) => {
      const parsedUrl = parse(req.url, true);
      const { pathname } = parsedUrl;
      const filePath = join(__dirname, '..', '.next', pathname);

      console.log(filePath);

      app.serveStatic(req, res, filePath);
    });

    server.get('/session/:slug', (req, res) => {
      const { slug } = req.params;
      app.render(req, res, '/session', { ...req.query, slug });
    });

    // now boilerplate continues…

    // pass all other requests directly to next's handler
    server.get('*', (req, res) => handle(req, res));

    server.listen(port, err => {
      if (err) throw err;
      console.log(`> Ready on http://localhost:${port}`);
    });
  })
  .catch(ex => {
    console.error(ex.stack);
    process.exit(1);
  });
