/* eslint-env node */
const express = require('express');
const app = express();
const fs = require('fs');

const files = fs
  .readdirSync('.')
  .filter(_ => _.endsWith('.json') && !_.startsWith('schedule'))
  .map(_ => ({ data: require(`./${_}`), slug: _.replace(/\.json$/, '') }));

const schedule = require('./schedule.json');

app.use(function(req, res, next) {
  res.header('Access-Control-Allow-Origin', '*');
  res.header(
    'Access-Control-Allow-Headers',
    'Origin, X-Requested-With, Content-Type, Accept'
  );
  next();
});

app.get('/event/2018', (req, res) => res.json(schedule));
app.get('/session/:slug', (req, res) =>
  res.json(files.find(_ => _.slug === req.params.slug).data)
);

app.use((error, req, res, next) =>
  res.status(404).json({ error: 'not found' })
);

app.listen(process.env.PORT || 9000);
