import propTypes from 'prop-types';
import Link from 'next/link';

import styles from './sessions.css';

const Sessions = ({ sessions }) => (
  <ul>
    <style jsx>{styles}</style>
    <style jsx>{`
      .info .speaker {
        display: ${process.env.HIDE_SPEAKERS ? 'none' : 'auto'};
      }
    `}</style>
    {sessions.map(session => (
      <li key={session.slug}>
        <p className="title">
          <Link
            href={`/session?slug=${session.slug}`}
            as={`/session/${session.slug}`}
          >
            <a>{session.title}</a>
          </Link>
        </p>
        <p className="info">
          <span>⏰ {session.time}</span>
          <span className="speaker">{session.speaker.name}</span>
          <span className="speaker">
            <a
              href={`https://twitter.com/${session.speaker.twitter}`}
              target="_blank"
            >
              @{session.speaker.twitter}
            </a>
          </span>
        </p>
      </li>
    ))}
  </ul>
);

Sessions.propTypes = {
  sessions: propTypes.arrayOf(
    propTypes.shape({
      time: propTypes.string,
      speaker: propTypes.object,
      slug: propTypes.string,
    })
  ),
};

export default Sessions;
