import Link from 'next/link';

const Header = ({ user }) => (
  <header>
    <style jsx>{`
      ul {
        display: flex;
      }

      .user {
        flex-grow: 1;
        text-align: right;
      }

      .avatar {
        object-fit: contain;
        width: 29px;
        height: 29px;
        display: block;
        margin-left: auto;
        border-radius: 9999px;
      }
    `}</style>
    <nav>
      <ul>
        <li>
          <Link href="/">
            <a>Talks</a>
          </Link>
        </li>
        <li>
          <Link href="/about">
            <a>About</a>
          </Link>
        </li>
        <li>
          <Link href="/contact">
            <a>Contact</a>
          </Link>
        </li>
        <li className="user">
          {user ? (
            <img className="avatar" src={user.avatar} />
          ) : (
            <Link href="/login">
              <a>Log in</a>
            </Link>
          )}
        </li>
      </ul>
    </nav>
  </header>
);

Header.defaultProps = {
  user: null,
};

export default Header;
